<?php
/**
#########################################################################################################
# Copyright (c) 2009 CustomCode.info. All Rights Reserved.
# URL:              [url]http://customcode.info[/url]
# Function:         cURL
# Author:           fwhite
# Language:         PHP
# License:          CBLA v1 - http://cbla.cbdev.org
# Version:          $Id: cURL.get.php 320 2009-11-20 21:52:36Z fwhite $
# Created:          Tuesday, November 10, 2009 / 09:52 PM GMT+1 (fwhite)
# Last Modified:    $Date: 2009-11-20 22:52:36 +0100 (Fri, 20 Nov 2009) $
# Notice:           Please maintain this section
#########################################################################################################
*/
error_reporting(E_ALL);
ini_set('display_errors', '1');
if (function_exists('set_time_limit') AND get_cfg_var('safe_mode') == 0)
{
	@set_time_limit(0);
}
require_once('includes/config.inc.php');
$userquery->logincheck();

if(!function_exists('curl_init'))
{
    exit('cURL not installed');
}

    /**
    * cURL FOLLOW_LOCATION workaround
    * source: http://www.edmondscommerce.co.uk/blog/curl/php-curl-curlopt_followlocation-and-open_basedir-or-safe-mode/
    * source: http://au.php.net/manual/ro/function.curl-setopt.php#71313
    */
    function curl_redir_exec($ch, $logName)
    {
        $log = fopen($logName,'w');
        fwrite($log, date('l, F j, Y / h:i:s A T (\G\M\TO)'). "\n", 1024);

        static $curl_loops = 0;
        static $curl_max_loops = 20;
        if ($curl_loops++>= $curl_max_loops)
        {
            $curl_loops = 0;
            return FALSE;
        }

        curl_setopt($ch, CURLOPT_STDERR,$log);
        $data       = curl_exec($ch);
        $error      = curl_error($ch);
        $error_no   = curl_errno($ch);
        $return     = (empty($data)) ? 'failed' : $data;

        if(empty($error))
        {
            fwrite($log, "curl Result: ".$return. "\n", 1024);
        }
        else
        {
            $message    = "curl error message: ".$error."\n";
            $message   .= "curl error #: ".$error_no;
            fwrite($log, $message. "\n", 1024);
        }
        fclose($log);
        $info   = file_get_contents($logName);
        $log    = fopen($logName,'a');
        $txt    = var_export(curl_getinfo($ch), true);
        fwrite($log, $txt. "\n", 1024);
        // END DEBUG

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if ($http_code == 301 || $http_code == 302)
        {
            preg_match('/Location:(.*?)\n/', $info, $test);
            foreach($test as $key=>$value)
            {
                fwrite($log, "Redirect: ".$value."\n");
            }

            $url = trim($test[1]);
            $url = parse_url($url);

        if (!isset($url))
        {
            // couldn't process the url to redirect to
            $curl_loops = 0;
            return $data;
        }
        $last_url = parse_url(curl_getinfo($ch, CURLINFO_EFFECTIVE_URL));
        if (!isset($url['scheme']))
        {
            $url['scheme'] = $last_url['scheme'];
        }
        if (!isset($url['host']))
        {
            $url['host'] = $last_url['host'];
        }
        if (!isset($url['path']))
        {
            $url['path'] = $last_url['path'];
        }
            $url['query'] = (isset($url['query'])) ? '?'.$url['query'] : '';

            $new_url = $url['scheme'] . '://' . $url['host'] . $url['path'] . $url['query'];
            curl_setopt($ch, CURLOPT_URL, $new_url);
            fclose($log);
            return curl_redir_exec($ch, $log);
        }
        else
        {
            $curl_loops=0;
            fclose($log);
            return $data;
        }
    }

if(!empty($_POST['file']) && !empty($_POST['flvname']))
{
    require_once('includes/classes/conversion/ffmpeg.class.php');
    $ffmpeg = new ffmpeg();

    $Upload->UploadProcess();
    $filename	    = basename($_POST['file']);
    $ffmpeg->AssignDefaultThumb($filename);
    $flv	        = $_POST['flvname'];
	$new_name	    = substr($flv, 0, strrpos($flv, '.'));
	$ext		    = substr($filename, strrpos($filename,'.') + 1);
	$newfilename	= $new_name.".".$ext;

    /**
     * Initialize the cURL session
     */
    $ch         = curl_init();
    // Specify the username/password to use, or leave blank for no auth
    $user       = "";
    $password   = "";
    $url        = $_REQUEST['file'];
    /**
     * Set the URL of the page or file to download.
     */
    $logName    = BASEDIR.'/logs/curl/'.$newfilename.'.log';
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch, CURLOPT_REFERER, 'http://google.com');
    curl_setopt($ch, CURLOPT_TIMEOUT, 300);
    curl_setopt($ch, CURLOPT_VERBOSE,1);
    /**
     * Create a new file
     */
    $fp = fopen(BASEDIR.'/files/temp/'.$newfilename, 'w');
    /**
     * Ask cURL to write the contents to a file
     */
    curl_setopt($ch, CURLOPT_FILE, $fp);
    // provide credentials if they're established at the beginning of the script
    if(!empty($user) && !empty($password))
    {
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch,CURLOPT_USERPWD,$user . ":" . $password);
    }
    if(ereg("^(https)",$url))
    {
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
    }
    if (ini_get('open_basedir') == '' && (ini_get('safe_mode' == 'Off') || ini_get('safe_mode') == 0))
    {
        $log        = fopen($logName,'w');
        fwrite($log, date('l, F j, Y / h:i:s A T (\G\M\TO)'). "\n", 1024);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION,1);
        curl_setopt($ch, CURLOPT_STDERR,$log);
        curl_setopt($ch, CURLOPT_MAXREDIRS, 5);
        // execute, and log the result to curl_put.log
        $result     = curl_exec($ch);
        // START DEBUG
        $txt        = var_export(curl_getinfo($ch), true);
        $error      = curl_error($ch);
        $error_no   = curl_errno($ch);
        $return     = (empty($result)) ? 'failed' : $result;
        if(empty($error))
        {
            fwrite($log, "curl Result: ".$return. "\n", 1024);
        }
        else
        {
            $message    = "curl error message: ".$error."\n";
            $message   .= "curl error #: ".$error_no;
            fwrite($log, $message. "\n", 1024);
        }
        // END DEBUG
        fwrite($log, $txt. "\n", 1024);
        fclose($log);
    }
    else
    {
        $result     = curl_redir_exec($ch, $logName);
    }

    $httpResponse = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if($httpResponse == 200)
    {
        $video_file = BASEDIR.'/files/temp/'.$newfilename;
        if(is_valid_file($video_file))
        {
            $ffmpeg->ConvertFile($newfilename,$flv);
        }
        else
        {
            unlink($video_file);
        }
        header('Location: manage_videos.php');
    }
    else
    {
        // do failed DB stuff
        $sql    = "UPDATE video SET status = 'Failed' WHERE flv = '".$flv."' LIMIT 1";
        mysql_query($sql) or die(mysql_error());

        $sql    = "INSERT INTO video_detail (flv,status,duration,original) ";
        $sql    .= "VALUES ('".$flv."','Failed','0','".mysql_real_escape_string($url)."')";
        mysql_query($sql) or die(mysql_error());
        header('Location: manage_videos.php');
    }
}
else
{
    header('Location: videos.php');
}

?>