<?php
/**
***************************************************************************************************
 * @Software    ClipBucket
 * @Author      Arslan Hassan, et al
 * @Copyright	Copyright (c) 2007-2008. All Rights Reserved.
 * @URL        	http://www.clip-bucket.com
 * @Version		$Id: ffmpeg.class.php 318 2009-11-13 22:23:39Z fwhite $
 * @Created 	10-15-2007
 * @License		CBLA v1 - http://cbla.cbdev.org
 **************************************************************************************************
 This source code is licensed under the terms of the CBLA v1
 http://cbla.cbdev.org
 **************************************************************************************************
 Copyright (c) 2007-2008 Clip-Bucket.com. All Rights Reserved.
 **************************************************************************************************
**/
 
if (function_exists('set_time_limit') AND get_cfg_var('safe_mode')==0)
{
	@set_time_limit(0);
}
ignore_user_abort(true);
define('ENCODING_LOGGING','yes');
class ffmpeg
{

           /**
	        *
	        * @param int $duration Movie Times
	        * @param int $rand Random Switch 1 or 0
	        * @return int $time return Time 00:00
	        *
	        **/
			function ChangeTime($duration){
				if($duration / 3600 > 1 ){
				$time = date("H:i:s",$duration - rand(0,$duration));
				}else{
				$time = "00:";
				$time .= date("i:s",$duration - rand(0,$duration));
				}
				return $time;
			}


    	/**
	     * THIS FUNCTION IS USED TO GENERATE THUMBS
	     *
	     * @param string $flv flash video name
	     * @param int $duration video duration
    	 * @param int $rand random time switch 1 or 0
	     *
         **/
        function AssignGeneratedThumbs($flv,$duration,$rand = NULL)
        {
            $resize_cmd             = "";
			$filename_minus_ext     = substr($flv, 0, strrpos($flv, '.'));
			$thumbnail_output_dir   = BASEDIR.'/files/thumbs';
			$ffmpeg 		        = FFMPEG_BINARY;
			$flv_file		        = BASEDIR.'/files/videos/'.$flv;
            $log_base               = BASEDIR."/logs/".$filename_minus_ext;
            $big_log                = BASEDIR."/logs/".$filename_minus_ext."-thumb-big.log";
            $single_log             = BASEDIR."/logs/".$filename_minus_ext."-thumbs.log";
            $ffmpeg_log             = BASEDIR.'/logs/'.$filename_minus_ext.'-ffmpeg.log';
            $random_time            = $this->ChangeTime($duration,1);

                $this->DeleteThumbs($flv);

				for($id=1;$id<=3;$id++){
				$time 	 = $this->ChangeTime($duration,1);
				$command = "$ffmpeg -i $flv_file -an -ss $time -an -r 1 -s 120x90 -y -f image2 -vframes 1 $thumbnail_output_dir/$filename_minus_ext-$id.jpg";
                $command = $command.' &> '.$log_base.'-thumb-'.$id.'.log';
                $this->WriteLog($ffmpeg_log,$command);
                exec($command);
                }
                // BEGIN if not exists
                for($id=1;$id<=3;$id++)
                {
                $time 	= $this->ChangeTime($duration,1);
                if(!file_exists($thumbnail_output_dir."/".$filename_minus_ext.'-'.$id.'.jpg'))
                {
				$command = "$ffmpeg -i $flv_file -an -ss $time -an -r 1 -s 120x90 -y -f image2 -vframes 1 $thumbnail_output_dir/$filename_minus_ext-$id.jpg";
                $command = $command.' &> '.$log_base.'-thumb-'.$id.'.log';
                $this->WriteLog($ffmpeg_log,$command);
                exec($command);
                }
                }
                // END if not exists
				$command2 = "$ffmpeg -i $flv_file -ss $random_time -an -y -f image2 -vframes 1 $thumbnail_output_dir/$filename_minus_ext-big.jpg";
                $command2 = $command2.' &> '.$big_log;
                $this->WriteLog($ffmpeg_log,$command2);
                exec($command2);
            }

    	/**
	     * generate thumbs w/ specific time
	     * @param string $flv: flash video name
	     * @param string $time: hh:mm:ss
         **/
        function GenCustomThumb($flv,$time)
        {
            $resize_cmd             = "";
			$filename_minus_ext     = substr($flv, 0, strrpos($flv, '.'));
			$thumbnail_output_dir   = BASEDIR.'/files/thumbs';
			$ffmpeg 		        = FFMPEG_BINARY;
			$flv_file		        = BASEDIR.'/files/videos/'.$flv;
            $log_base               = BASEDIR."/logs/".$filename_minus_ext;
            $big_log                = BASEDIR."/logs/".$filename_minus_ext."-thumb-big.log";
            $single_log             = BASEDIR."/logs/".$filename_minus_ext."-thumbs.log";
            $ffmpeg_log             = BASEDIR.'/logs/'.$filename_minus_ext.'-ffmpeg.log';

            $this->DeleteThumbs($flv);

            for($id=1;$id<=3;$id++)
            {
                $command = "$ffmpeg -i $flv_file -an -ss $time -an -r 1 -s 120x90 -y -f image2 -vframes 1 $thumbnail_output_dir/$filename_minus_ext-$id.jpg";
                $command = $command.' &> '.$log_base.'-thumb-'.$id.'.log';
                $this->WriteLog($ffmpeg_log,$command);
                exec($command);
            }

            // BEGIN if not exists
            for($id=1;$id<=3;$id++)
            {
                if(!file_exists($thumbnail_output_dir."/".$filename_minus_ext.'-'.$id.'.jpg'))
                {
				    $command = "$ffmpeg -i $flv_file -an -ss $time -an -r 1 -s 120x90 -y -f image2 -vframes 1 $thumbnail_output_dir/$filename_minus_ext-$id.jpg";
                    $command = $command.' &> '.$log_base.'-thumb-'.$id.'.log';
                    $this->WriteLog($ffmpeg_log,$command);
                    exec($command);
                }
            }
            // END if not exists
			$command2 = "$ffmpeg -i $flv_file -ss $time -an -y -f image2 -vframes 1 $thumbnail_output_dir/$filename_minus_ext-big.jpg";
            $command2 = $command2.' &> '.$big_log;
            $this->WriteLog($ffmpeg_log,$command2);
            exec($command2);
        }

    	/**
	     * generate thumb w/ specific time
	     * @param string $flvname: video location
         * @param string $output: thumb destination
	     * @param string $time: hh:mm:ss
         * @param string thumbnail name
         * @param string thumbnail resolution (WxH)
         **/
        function GenOneThumb($flvname,$output,$time,$thumbnail,$res)
        {
			$ffmpeg 		        = FFMPEG_BINARY;
            $name                   = basename($output);
            $filename_minus_ext     = substr($name, 0, strrpos($name, '.'));
            $log_base               = BASEDIR."/logs/".$name;
            $single_log             = BASEDIR."/logs/".$name."-customthumb.log";
            $ffmpeg_log             = BASEDIR.'/logs/'.$name.'-ffmpeg.log';

            if(file_exists($flvname) && filesize($flvname) > 0)
            {
                $command = "$ffmpeg -i $flvname -an -ss $time -an -r 1 -s $res -y -f image2 -vframes 1 $output";
                $command = $command.' &> '.$single_log;
                $this->WriteLog($ffmpeg_log,$command);
                exec($command);

                // BEGIN if not exists
                if(!file_exists($thumbnail_output_dir."/".$filename_minus_ext.'-'.$id.'.jpg'))
                {
                    $command = "$ffmpeg -i $flvname -an -ss $time -an -r 1 -s $res -y -f image2 -vframes 1 $ouput";
                    $command = $command.' &> '.$single_log;
                    $this->WriteLog($ffmpeg_log,$command);
                    exec($command);
                }
            // END if not exists
            }
        }
			
           /**
	        * This function is used to generate default thumbs
	        *
	        * @param string $flv Flash Video Name
	        *
	        **/
			function AssignDefaultThumb($flv){
			// remove file extension
			$filename_minus_ext = substr($flv, 0, strrpos($flv, '.'));
			$proccesing_thumb = TEMPLATEDIR.'/images/'.LANG.'/processing.png';
			$proccesing_thumb_big = TEMPLATEDIR.'/images/'.LANG.'/processing-big.png';
			copy($proccesing_thumb,BASEDIR.'/files/thumbs/'.$filename_minus_ext.'-1.jpg');
			copy($proccesing_thumb,BASEDIR.'/files/thumbs/'.$filename_minus_ext.'-2.jpg');
			copy($proccesing_thumb,BASEDIR.'/files/thumbs/'.$filename_minus_ext.'-3.jpg');	
			copy($proccesing_thumb_big,BASEDIR.'/files/thumbs/'.$filename_minus_ext.'-big.jpg');
			
			}

	function exec($cmd) {
		# use bash to execute the command
		# add common locations for bash to the PATH
		# this should work in virtually any *nix/BSD/Linux server on the planet
		# assuming we have execute permission
		//$cmd = "PATH=\$PATH:/bin:/usr/bin:/usr/local/bin bash -c \"$cmd\" ";
		return exec($cmd);
	}

	function shellexec($cmd) {
		# use bash to execute the command
		# add common locations for bash to the PATH
		# this should work in virtually any *nix/BSD/Linux server on the planet
		# assuming we have execute permission
		//$cmd = "PATH=\$PATH:/bin:/usr/bin:/usr/local/bin bash -c \"$cmd\" ";
		return shell_exec($cmd);
	}

	/**
	 * get encoding progress
	 * @author Arslan Hassan
     * @author Pedro
	 * @param string $path_source Video File
	 * @return mixed false on error, true on $info
	 *
	**/
	function get_file_info($path_source,$filename = NULL) {
	    if(!is_null($filename))
        {
        $file_noext     = substr($filename, 0, strrpos($filename, '.'));
	    $log            = BASEDIR.'/logs/'.$file_noext.'-source_info.log';
        }
		$ffmpeg         = FFMPEG_BINARY;
		# init the info to N/A
		$info['format']			    = 'N/A';
		$info['duration']		    = 'N/A';
		$info['size']			    = 'N/A';
		$info['bitrate']		    = 'N/A';
		$info['video_width']	    = 'N/A';
		$info['video_height']	    = 'N/A';
		$info['video_wh_ratio']	    = 'N/A';
		$info['video_codec']	    = 'N/A';
		$info['video_rate']		    = 'N/A';
		$info['video_bitrate']	    = 'N/A';
        $info['video_frames']	    = 'N/A';
		$info['video_color']	    = 'N/A';
        $info['video_par']	        = 'N/A';
        $info['video_dar']	        = 'N/A';
        $info['video_par_calc']	    = 'N/A';
		$info['audio_codec']	    = 'N/A';
		$info['audio_bitrate']	    = 'N/A';
		$info['audio_rate']	        = 'N/A';
		$info['audio_channels']	    = 'N/A';
		# get the file size
		$stats = stat( $path_source );
		if( $stats === false )
			trigger_error( "Failed to stat file $path_source!", E_USER_ERROR );
		$info['size'] = (integer)$stats['size'];
        if(!is_null($filename))
        {
		$this->shellexec( "$ffmpeg -i '$path_source' -acodec copy -vcodec copy -f null /dev/null 2>&1 &> $log" );
        }
        $output = $this->shellexec( "$ffmpeg -i '$path_source' -acodec copy -vcodec copy -f null /dev/null 2>&1" );
		# parse output
		if($this->parse_format_info($output, $info) === false)
			return false;

		return $info;
	}

	function get_source_info($path_source,$filename = NULL) {
	    if(!is_null($filename))
        {
        $file_noext     = substr($filename, 0, strrpos($filename, '.'));
	    $log            = BASEDIR.'/logs/'.$file_noext.'-source_info.log';
        }
		$ffmpeg         = FFMPEG_BINARY;
		# init the info to N/A
		$info['format']			    = 'N/A';
		$info['duration']		    = 'N/A';
		$info['size']			    = 'N/A';
		$info['bitrate']		    = 'N/A';
		$info['video_width']	    = 'N/A';
		$info['video_height']	    = 'N/A';
		$info['video_wh_ratio']	    = 'N/A';
		$info['video_codec']	    = 'N/A';
        $info['video_frames']	    = 'N/A';
		$info['video_rate']		    = 'N/A';
		$info['video_bitrate']	    = 'N/A';
		$info['video_color']	    = 'N/A';
        $info['video_par']	        = 'N/A';
        $info['video_dar']	        = 'N/A';
        $info['video_par_calc']	    = 'N/A';
		$info['audio_codec']	    = 'N/A';
		$info['audio_bitrate']	    = 'N/A';
		$info['audio_rate']	        = 'N/A';
		$info['audio_channels']	    = 'N/A';
		# get the file size
		$stats = stat( $path_source );
		if( $stats === false )
			trigger_error( "Failed to stat file $path_source!", E_USER_ERROR );
		$info['size'] = (integer)$stats['size'];
        $output = $this->shellexec( "$ffmpeg -i '$path_source' -acodec copy -vcodec copy -f null /dev/null 2>&1" );
		# parse output
		if($this->parse_format_info($output, $info) === false)
			return false;

		return $info;
	}

	/**
	 * parse format info
	 * @author Arslan Hassan
     * @author Pedro
	 * @param string $output the ffmpeg output to be parsed to extract format info
	 * @param array &$info see function get_encoding_progress
	 * @return bool false on error, true on success
	 *
	**/
	function parse_format_info( $output, & $info ) {

		# search the output for specific patterns and extract info
		# check final encoding message
		if( ereg( 'Unknown format', $output, $args) ) {
			$Unkown = "Unknown";
		} else {
			$Unkown = "";
		}
		if( ereg( 'video:([0-9]+)kB audio:([0-9]+)kB global headers:[0-9]+kB muxing overhead', $output, $args ) ) {
			$video_size = (float)$args[1];
			$audio_size = (float)$args[2];
		} else {
			return false;
		}

		# check for last enconding update message
		if( ereg( '(frame=([^=]*) fps=[^=]* q=[^=]* L)?size=[^=]*kB time=([^=]*) bitrate=[^=]*kbits/s[^=]*$', $output, $args ) ) {
			$frame_count            = $args[2] ? (float)$args[2] : 0;
            $info['video_frames']   = $frame_count;
			$duration               = (float)$args[3];
		} else {
			return false;
		}

		$info['duration']           = $duration;
		$info['bitrate']            = (integer)($info['size'] * 8 / 1024 / $duration);
		if( $frame_count > 0 )
			$info['video_rate']	    = (float)$frame_count / (float)$duration;
		if( $video_size > 0 )
			$info['video_bitrate']	= (integer)($video_size * 8 / $duration);
		if( $audio_size > 0 )
			$info['audio_bitrate']	= (integer)($audio_size * 8 / $duration);
			# get format information
		if( ereg( "Input #0, ([^ ]+), from", $output, $args ) ) {
			$info['format']         = $args[1];
		}

		# get video information
		if( ereg( 'Video: ([^ ]+), ([^ ]+), ([0-9]+)x([0-9]+)( \[PAR ([0-9]+):([0-9]+) DAR ([0-9]+):([0-9]+)\])?', $output, $args ) ) {
			$info['video_codec']    = $args[1];
			$info['video_color']    = $args[2];
			$info['video_width']    = $args[3];
			$info['video_height']   = $args[4];
			if( $args[5] ) {
				$par1                   = $args[6];
				$par2                   = $args[7];
                $info['video_par']      = $args[6].':'.$args[7];
                $info['video_par_calc'] = round($args[3] * $args[6] / $args[7]);
				$dar1                   = $args[8];
				$dar2                   = $args[9];
                $info['video_dar']      = $args[8].':'.$args[9];
				if( (int)$dar1 > 0 && (int)$dar2 > 0  && (int)$par1 > 0 && (int)$par2 > 0 )
					$info['video_wh_ratio'] = ( (float)$dar1 / (float)$dar2 ) / ( (float)$par1 / (float)$par2 );
			}
			# laking aspect ratio information, assume pixel are square
			if( $info['video_wh_ratio'] === 'N/A' )
				$info['video_wh_ratio'] = (float)$info['video_width'] / (float)$info['video_height'];
		}

		# get audio information
		if( ereg( "Audio: ([^ ]+), ([0-9]+) Hz, ([^\n,]*)", $output, $args ) ) {
			$info['audio_codec']    = $args[1];
			$info['audio_rate']     = $args[2];
			$info['audio_channels'] = $args[3];
		}

		# check if file contains a video stream
		return $video_size > 0;

		#TODO allow files with no video (only audio)?
		#return true;
	}
			
	/**
	 * This function is used to validate filetype
	 *
	 * @param string $file File name
	 * return bool true or false
	 *
	**/
			function ValidateFile($file) {
				global $row;
				$ph = substr($file, strrpos($file,'.') + 1);
				$ph = strtolower($ph); // Added line to fix case
				$types = strtolower($row['allowed_types']);
				$types_array = preg_replace('/,/',' ',$types);
				$types_array = explode(' ',$types_array);
				foreach($types_array as $type) {
					$return = false;
					if($type == $ph) {
						$return = true;
						break;
					}
				}
				return $return;
			}
			
	    /**
	    * THE REAL ENCODING GOES HERE
	    *
	    * @param string $file Filename
	    * @param string $flv Flash Video Name
	    *
	    **/
			function ConvertFile($file,$flv)
            {
				$video_file     = BASEDIR.'/files/temp/'.$file;
				$flv_file       = BASEDIR.'/files/videos/'.$flv;
                $flv_noext      = substr($flv, 0, strrpos($flv, '.'));
                $log_base       = BASEDIR.'/logs/'.$flv_noext;
                $single_log     = BASEDIR.'/logs/'.$flv_noext.".log";
                $flvtool2_log   = BASEDIR.'/logs/'.$flv_noext."-flvtool2.log";
                /// log source info
                $source_info    = $this->get_file_info($video_file,$flv);
                $sec            = $source_info['duration'];
                $source_log     = BASEDIR.'/logs/'.$flv_noext.'-source.log';
                $ffmpeg_log     = BASEDIR.'/logs/'.$flv_noext.'-ffmpeg.log';
				
				if($this->ValidateFile($file)){
				$mencoder 		= FFMPEG_MENCODER_BINARY;
				$mplayer 		= FFMPEG_MPLAYER_BINARY;
				$flvtool2 		= FFMPEG_FLVTOOLS_BINARY;
                $srate			= SRATE;
                $vbrate 		= VBRATE;
                if($vbrate != 'same as source')
                {
                $changeVideo    = 1;
                }
                if($srate != 'same as source')
                {
                $changeAudio    = 1;
                }
				$r_height		= R_HEIGHT;
				$ffmpeg 		= FFMPEG_BINARY;
				$r_width		= R_WIDTH;
				$resize			= RESIZE;
				$keep_original	= KEEP_ORIGINAL;
				$max_size		= MAX_UPLOAD_SIZE;
				
				
				// check video file size
				$size       = @filesize($flv_file);
				if($size > $max_size*1024*1024){
				$status     = "Failed";
				$flv_file   = "failed.flv";
				}else{

				$scale      = "";
                $f_scale    = "";
				if($resize == 'yes'){
						$scale      = "scale=".$r_width.":".$r_height;
						$f_scale    = "-s ".$r_width."x".$r_height;
				}
					$extension = substr($file, strrpos($file,'.') + 1);

					/////////////////////////////////////////////////////////////
					//                        STEP 1                           //
					//                  encode video to flv                    //
					/////////////////////////////////////////////////////////////

					// check the extension of the uploaded video and checks its encoding command against each case
					$extension = strtolower($extension);
					switch($extension){

					/*case 'wmv';
                    // do WMV stuff
					break;*/

					// FLV
					case 'flv';
					copy($video_file,$flv_file);
                    if(file_exists($flv_file))
                    {
                    $this->WriteLog($single_log,$video_file." copied to ".$flv_file);
                    }
					break;

					default:

/*                    if($changeVideo == 1 && $changeAudio == 1)
                    {
					$command = "$ffmpeg -i $video_file -b $vbrate -maxrate $vbrate -bufsize 750k -ab $srate -ar 44100 $f_scale $flv_file";
                    }
                    elseif($changeVideo == 1 && !$changeAudio)
                    {
                    $command = "$ffmpeg -i $video_file -b $vbrate -maxrate $vbrate -bufsize 750k -ab 64k -ar 44100 $f_scale $flv_file";
                    }
                    elseif($changeAudio == 1 && !$changeVideo)
                    {
                    $command = "$ffmpeg -i $video_file -b 300k -maxrate 300k -bufsize 750k -ab $srate -ar 44100 $f_scale $flv_file";
                    }
                    else
                    {
                    $command = "$ffmpeg -i $video_file -b 300k -maxrate 300k -bufsize 750k -ab 64k -ar 44100 $f_scale $flv_file";
                    }*/

                    if($resize == 'yes')
                    {
					$command    = "$ffmpeg -i $video_file -maxrate 300k -bufsize 750k -ar 44100 -ab 64k -f flv $f_scale $flv_file";
                    }
                    else
                    {
                    $command    = "$ffmpeg -i $video_file -maxrate 300k -bufsize 750k -ar 44100 -ab 64k -f flv $flv_file";
                    }
                    $command    = $command.' &> '.$single_log;
                    $this->WriteLog($ffmpeg_log,$command);
                    @exec($command);
					}
					
					/////////////////////////////////////////////////////////////
					//                        STEP 2                           //
					//                  FLVTOOL2 INJECTION                     //
					/////////////////////////////////////////////////////////////;
					$flv_cmd = "$flvtool2 -vDUP $flv_file";
                    $flv_cmd = $flv_cmd.' &> '.$flvtool2_log;
                    $this->WriteLog($ffmpeg_log,$flv_cmd);
					@exec($flv_cmd);
                    chmod($flv_file,0777);

						if($keep_original == 1){
						$original_file = BASEDIR.'/files/original/'.$file;
						copy($video_file,$original_file);
						}
	
						$status = "Successful";
				
						
						//If MAX SIZE CONDITION ENDs	
						mysql_query("INSERT INTO video_detail(flv,status,duration,original) VALUES ('".$flv."','".$status."','".$sec."','".$file."')");
						mysql_query("UPDATE video SET duration='".$sec."' , status='".$status."' WHERE flv = '".$flv."'");

						$this->AssignGeneratedThumbs($flv,$sec);
					}
					}
						unlink($video_file);
						if(!file_exists($flv_file)){
						$status = "Failed";
						$this->AssignDefaultThumb($flv);						
						mysql_query("UPDATE video_detail SET status='".$status."' WHERE flv = '".$flv."'");
						mysql_query("UPDATE video SET active='no'  AND status='".$status."' WHERE flv = '".$flv."'");
						}
				}

    function DeleteThumbs($flv)
    {
        $filename_minus_ext = substr($flv, 0, strrpos($flv, '.'));
        $thumbnail_dir = BASEDIR.'/files/thumbs/';
        if(file_exists($thumbnail_dir.$filename_minus_ext.'-1.jpg'))
        {
            unlink($thumbnail_dir.$filename_minus_ext.'-1.jpg');
        }
        if(file_exists($thumbnail_dir.$filename_minus_ext.'-2.jpg'))
        {
            unlink($thumbnail_dir.$filename_minus_ext.'-2.jpg');
        }
        if(file_exists($thumbnail_dir.$filename_minus_ext.'-3.jpg'))
        {
            unlink($thumbnail_dir.$filename_minus_ext.'-3.jpg');
        }
        if(file_exists($thumbnail_dir.$filename_minus_ext.'-big.jpg'))
        {
            unlink($thumbnail_dir.$filename_minus_ext.'-big.jpg');
        }
    }

    function WriteLog($filename, $msg)
    {
	    $fd = fopen($filename, "a");
        fwrite($fd, "[" .date('l, F j, Y / h:i:s A T (\G\M\TO)'). "] -- ", 1024);
	    fwrite($fd, $msg. "\n", 1024);
	    fclose($fd);
    }

    // source http://www.gidforums.com/t-3353.html
    function is_odd($int)
    {
        return($int & 1);
    }

		/**
		 * Returns the available codecs.
		 * @access public
		 * @return array An array of codecs available to ffmpeg.
		 */
		function getAvailableCodecs()
		{
		    $ffmpeg_check = exec('which ffmpeg');
            if(!empty($ffmpeg_check))
            {
                $info = $this->getFFmpegInfo();
		        return array_keys($info['formats']);
            }
            else
            {
                return 0;
            }
		}

		/**
		 * Returns decodable codecs only.
		 * @access public
		 * @return array An array of codecs available to ffmpeg.
		 */
		function getDecodableCodecs($codec_only = 1)
		{
		    $ffmpeg_check   = exec('which ffmpeg');
            if(!empty($ffmpeg_check))
            {
            $info           = $this->getFFmpegInfo();
            $formats        = $info['formats'];
            $delete_key     = "decode";
            foreach ($formats as $key => $data)
            {
            if ($formats[$key][$delete_key] != 1)
            {
            unset($formats[$key]);
            }
            }
            if($codec_only == 1)
            {
            return array_keys($formats);
            }
            else
            {
            return $formats;
            }
            }
            else
            {
            return 0;
            }
		}

		/**
		 * Returns decodable codecs only.
		 * @access public
		 * @return array An array of codecs available to ffmpeg.
		 */
		function getEncodableCodecs($codec_only = 1)
		{
		    $ffmpeg_check   = exec('which ffmpeg');
            if(!empty($ffmpeg_check))
            {
            $info           = $this->getFFmpegInfo();
            $formats        = $info['formats'];
            $delete_key     = "encode";
            foreach ($formats as $key => $data)
            {
            if ($formats[$key][$delete_key] != 1)
            {
            unset($formats[$key]);
            }
            }
            if($codec_only == 1)
            {
            return array_keys($formats);
            }
            else
            {
            return $formats;
            }
            }
            else
            {
            return 0;
            }
		}

		/**
		 * Returns information about the specified file without having to use ffmpeg-php
		 * as it consults the ffmpeg binary directly.
		 *
		 * @access public
		 * @return mixed false on error encountered, true otherwise
		 **/
		function getFFmpegInfo()
		{
			$format = '';
            // execute the ffmpeg lookup
			exec(FFMPEG_BINARY.' -formats 2>&1', $buffer);
			$buffer 			= implode("\r\n", $buffer);
            // start building the info array
			$data 				= array();
			$data['compiler']	= array();
			$data['binary']		= array();
			$look_ups 			= array('configuration'=>'configuration: ', 'formats'=>'File formats:', 'codecs'=>'Codecs:', 'filters'=>'Bitstream filters:', 'protocols'=>'Supported file protocols:', 'abbreviations'=>'Frame size, frame rate abbreviations:', 'Note:');
			$total_lookups 		= count($look_ups);
			$pregs 				= array();
			$indexs 			= array();
            // search for the content
			foreach($look_ups as $key=>$reg)
			{
				if(strpos($buffer, $reg) !== false)
				{
					$index = array_push($pregs, $reg);
					$indexs[$key] = $index;
				}
			}
			preg_match('/'.implode('(.*)', $pregs).'/s', $buffer, $matches);
			$configuration = trim($matches[$indexs['configuration']]);
            // grab the ffmpeg configuration flags
			preg_match_all('/--[a-zA-Z0-9\-]+/', $configuration, $config_flags);
			$data['binary']['configuration'] = $config_flags[0];
			$data['binary']['vhook-support'] = in_array('--enable-vhook', $config_flags[0]) || !in_array('--disable-vhook', $config_flags[0]);
            // grab the versions
			$data['binary']['versions'] = array();
			preg_match_all('/([a-zA-Z0-9\-]+) version: ([0-9\.]+)/', $configuration, $versions);
			for($i=0, $a=count($versions[0]); $i<$a; $i++)
			{
				$data['binary']['versions'][strtolower(trim($versions[1][$i]))] = $versions[2][$i];
			}
            // grab the ffmpeg compile info
			preg_match('/built on (.*), gcc: (.*)/', $configuration, $conf);
			if(count($conf) > 0)
			{
				$data['compiler']['gcc'] = $conf[2];
				$data['compiler']['build_date'] = $conf[1];
				$data['compiler']['build_date_timestamp'] = strtotime($conf[1]);
			}
            // grab the file formats available to ffmpeg
			preg_match_all('/ (DE|D|E) (.*) {1,} (.*)/', trim($matches[$indexs['formats']]), $formats);
			$data['formats'] = array();
            // loop and clean
			for($i=0, $a=count($formats[0]); $i<$a; $i++)
			{
				$data['formats'][strtolower(trim($formats[2][$i]))] = array(
					'encode' 	=> $formats[1][$i] == 'DE' || $formats[1][$i] == 'E',
					'decode' 	=> $formats[1][$i] == 'DE' || $formats[1][$i] == 'D',
					'fullname'	=> $formats[3][$i]
				);
			}
            // grab the bitstream filters available to ffmpeg
			$data['filters'] = array();
			if(isset($indexs['filters']) && isset($matches[$indexs['filters']]))
			{
				$filters = trim($matches[$indexs['filters']]);
				if(empty($filters))
				{
					$data['filters'] = explode(' ', $filters);
				}
			}
            // grab the file prototcols available to ffmpeg
			$data['filters'] = array();
			if(isset($indexs['protocols']) && isset($matches[$indexs['protocols']]))
			{
				$protocols = trim($matches[$indexs['protocols']]);
				if(empty($protocols))
				{
					$data['protocols'] = explode(' ', str_replace(':', '', $protocols));
				}
			}
            // grab the abbreviations available to ffmpeg
			$data['abbreviations'] = array();
			if(isset($indexs['abbreviations']) && isset($matches[$indexs['abbreviations']]))
			{
				$abbreviations = trim($matches[$indexs['abbreviations']]);
				if(empty($abbreviations))
				{
					$data['abbreviations'] = explode(' ', $abbreviations);
				}
			}
			$data['ffmpeg-php-support'] = $this->hasFFmpegPHPSupport();
			$data['raw'] 		= $buffer;
			$ffmpeg_info        = $data;
			return $data;
		}

		/**
		 * Determines the type of support that exists for the FFmpeg-PHP module.
		 *
		 * @access public
		 * @return mixed. Boolean false if there is no support, String 'module' if the actuall
		 * 		FFmpeg-PHP module is loaded, or String 'emulated' if the FFmpeg-PHP classes
		 * 		can be emulated through the adapter classes.
		 */
		function hasFFmpegPHPSupport()
		{
			return extension_loaded('ffmpeg') ? 'module' : false;
		}

		/**
		 * Checks to see if a given codec can be decoded by the current ffmpeg binary.
		 * @access public
		 * @param $codec string The shortcode for the codec to check for.
		 * @return boolean True if the codec can be decoded by ffmpeg, otherwise false.
		 */
		function canCodecBeDecoded($codec)
		{
			return $this->validateCodec($codec, 'decode');
		}

		/**
		 * Checks to see if a given codec can be decoded/encoded by the current ffmpeg binary.
		 * @access public
		 * @param $codec string The shortcode for the codec to check for.
		 * @param $method string 'encode' or 'decode', The method to check against the codec
		 * @return boolean True if the codec can be used with the diven method by ffmpeg, otherwise false.
		 */
		function validateCodec($codec, $method)
		{
		    $info = $this->getFFmpegInfo();
			return isset($info['formats'][$codec]) && isset($info['formats'][$codec][$method]) ? $info['formats'][$codec][$method] : false;
		}

		/**
		 * Checks to see if a given codec can be encoded by the current ffmpeg binary.
		 * @access public
		 * @param $codec string The shortcode for the codec to check for.
		 * @return boolean True if the codec can be encoded by ffmpeg, otherwise false.
		 */
		function canCodecBeEncoded($codec)
		{
			return $this->validateCodec($codec, 'encode');
		}

    /**
	 * List Available Codecs
	 *
	 * @author momo-i
	 * @param string $format Format Type Encode or Decode
	 * @param string $type Codec Type Video or Audio
	 * @return array List Available Codecs
	 *
	**/
	function list_codecs($format, $type) {

		if($format == "encode") {
			$formats = "E";
		} elseif ($format = "decode") {
			$formats = "D";
		} else {
			return false;
		}
		if($type == "video") {
			$types = "V";
		} elseif ($type == "audio") {
			$types = "A";
		}

		$ffmpeg         = FFMPEG_BINARY;
		exec("$ffmpeg -formats 2>&1", $output);

		$codecstart     = array_search('Codecs:', $output);
		$codecend       = array_search('Bitstream filters:', $output);
		$codecstart     = $codecstart + 1;
		$codecend       = $codecend - 2;

		$i = 0;

		foreach (range($codecstart, $codecend) as $number) {
			$output[$number]                    = preg_replace('/^\s+/', '', $output[$number]);
			$enc[$number]                       = preg_replace('/^([D E V A S T]+) (.+?)$/', '$1', $output[$number]);
			$tmp[$number]                       = preg_replace('/^([D E V A S T]+) (.+?)$/', '$2', $output[$number]);
			list($name[$number],$desc[$number]) = preg_split('/\s+/', $tmp[$number], 2);

			if(ereg($formats, $enc[$number])) {
				if(ereg($types, $enc[$number])) {
					$listing[$i] = array('encode/decode' => $enc[$number], 'name' => $name[$number], 'description' => $desc[$number]);
					$i++;
				}
			}
		}
		return $listing;
	}

	/**
	 * Calculate Size Padding
	 *
	 * @param string $parameters ffmpeg parameters
	 * @param string $source_info movie information
	 * @param int &$width width
	 * @param int &$height height
	 * @param int &$ratio ratio
	 * @param int &$pad_top top
	 * @param int &$pad_bottom bottom
	 * @param int &$pad_left left
	 * @param int &$pad_right right
	 *
	**/
	function calculate_size_padding( $parameters, $source_info, & $width, & $height, & $ratio, & $pad_top, & $pad_bottom, & $pad_left, & $pad_right ) {
		$p = $parameters;
		$i = $source_info;

		switch( $p['resize'] ) {
			# dont resize, use same size as source, and aspect ratio
			# WARNING: some codec will NOT preserve the aspect ratio
			case 'no':
				$width      = $i['video_width'   ];
				$height     = $i['video_height'  ];
				$ratio      = $i['video_wh_ratio'];
				$pad_top    = 0;
				$pad_bottom = 0;
				$pad_left   = 0;
				$pad_right  = 0;
				break;
			# resize to parameters width X height, use same aspect ratio
			# WARNING: some codec will NOT preserve the aspect ratio
			case 'WxH':
				$width  = $p['video_width'   ];
				$height = $p['video_height'  ];
				$ratio  = $i['video_wh_ratio'];
				$pad_top    = 0;
				$pad_bottom = 0;
				$pad_left   = 0;
				$pad_right  = 0;
				break;
			# make pixel square
			# reduce video size if bigger than p[width] X p[height]
			# and preserve aspect ratio
			case 'max':
				$width        = (float)$i['video_width'   ];
				$height       = (float)$i['video_height'  ];
				$ratio        = (float)$i['video_wh_ratio'];
				$max_width    = (float)$p['video_width'   ];
				$max_height   = (float)$p['video_height'  ];

				# make pixels square
				if( $ratio > 1.0 )
					$width = $height * $ratio;
				else
					$height = $width / $ratio;

				# reduce width
				if( $width > $max_width ) {
					$r       = $max_width / $width;
					$width  *= $r;
					$height *= $r;
				}

				# reduce height
				if( $height > $max_height ) {
					$r       = $max_height / $height;
					$width  *= $r;
					$height *= $r;
				}

				# make size even (required by many codecs)
				$width  = (integer)( ($width  + 1 ) / 2 ) * 2;
				$height = (integer)( ($height + 1 ) / 2 ) * 2;
				# no padding
				$pad_top    = 0;
				$pad_bottom = 0;
				$pad_left   = 0;
				$pad_right  = 0;
				break;
			# make pixel square
			# resize video to fit inside p[width] X p[height]
			# add padding and preserve aspect ratio
			case 'fit':
				# values need to be multiples of 2 in the end so
				# divide width and height by 2 to do the calculation
				# then multiply by 2 in the end
				$ratio        = (float)$i['video_wh_ratio'];
				$width        = (float)$i['video_width'   ] / 2;
				$height       = (float)$i['video_height'  ] / 2;
				$trt_width    = (float)$p['video_width'   ] / 2;
				$trt_height   = (float)$p['video_height'  ] / 2;

				# make pixels square
				if( $ratio > 1.0 )
					$width = $height * $ratio;
				else
					$height = $width / $ratio;

				# calculate size to fit
				$ratio_w = $trt_width  / $width;
				$ratio_h = $trt_height / $height;

				if( $ratio_h > $ratio_w ) {
					$width  = (integer)$trt_width;
					$height = (integer)($width / $ratio);
				} else {
					$height = (integer)$trt_height;
					$width  = (integer)($height * $ratio);
				}

				# calculate padding
				$pad_top    = (integer)(($trt_height - $height + 1) / 2);
				$pad_left   = (integer)(($trt_width  - $width  + 1) / 2);
				$pad_bottom = (integer)($trt_height  - $height - $pad_top );
				$pad_right  = (integer)($trt_width   - $width  - $pad_left);

				# multiply by 2 to undo division and get multiples of 2
				$width      *= 2;
				$height     *= 2;
				$pad_top    *= 2;
				$pad_left   *= 2;
				$pad_bottom *= 2;
				$pad_right  *= 2;
				break;
		}
	}

	/**
	 * Start Encoding
	 *
	 * @param mixed $parameters ffmpeg parameters
	 * @param mixed $source_info video information
	 * @param string $lockfile Encode Lock File
	 *
	**/
	function start_encoding( $parameters, $source_info, $lockfile ) {
		$ffmpeg = FFMPEG_BINARY;

		$p = & $parameters;
		$i = & $source_info;

		$opt_av = " -y ";
		$p['video_codec'];
		# Prepare the ffmpeg command to execute
		if(isset($p['extra_options']))
			$opt_av .= " -y {$p['extra_options']} ";

		# file format
		if(isset($p['format']))
			$opt_av .= " -f {$p['format']} ";
		# video codec, frame rate and bitrate
		$video_rate = min( $p['video_max_rate'], $i['video_rate'] );
		$opt_av .= " -vcodec {$p['video_codec']} -b {$p['video_bitrate']} -r $video_rate ";

		# video size, aspect and padding
		$this->calculate_size_padding( $p, $i, $width, $height, $ratio, $pad_top, $pad_bottom, $pad_left, $pad_right );
		$opt_av .= " -s {$width}x{$height} -aspect $ratio -padcolor 000000 -padtop $pad_top -padbottom $pad_bottom -padleft $pad_left -padright $pad_right ";

		# audio codec, rate and bitrate
		if(!empty($p['audio_codec']) && $p['audio_codec'] != 'None'){
		$opt_av .= " -acodec {$p['audio_codec']}";
		}
		# audio codec, rate and bitrate
		$opt_av .= " -ar {$p['audio_rate']} -ab {$p['audio_bitrate']} ";



		if(!isset($output))
			$output = "";
		//$lockfile = BASEDIR . "/files/temp/lock.tmp";
		# execute ffmpeg, send output to the log file, run in background, with low priority (niced)
		//$this->exec("echo $ffmpeg -i {$p['path_source']} $opt_av {$p['path_target']} >> {$p['path_log']} ");
		$this->exec( "$ffmpeg -i '{$p['path_source']}' $opt_av '{$p['path_target']}' &> '{$p['path_log']}'" );

		# Adding FLVtool2 for addin video meta deta
		if(!empty($p['flvtool2'])){
		$this->exec( "{$p['flvtool2']} -U {$p['path_target']} >> '{$p['path_log']}'" );
		$opt_av .= " {$p['flvtool2']} -U {$p['path_target']} >> '{$p['path_log']}'";
		}

		$this->exec( "echo $ffmpeg -i {$p['path_source']} $opt_av {$p['path_target']} >> '{$p['path_log']}'" );
	}
				
}
?>