<?php
/**
#########################################################################################################
# Copyright (c) 2009 ClipBucket / PHPBucket.com. All Rights Reserved.
# URL:              [url]http://clip-bucket.com[/url]
# Function:         Installer Functions
# Author:           fwhite
# Language:         PHP
# License:          CBLA @ [url]http://cbla.cbdev.org/[/url]
# Version:          $Id: functions.php 319 2009-11-14 21:15:20Z fwhite $
# Created:          Wednesday, August 26, 2009 / 02:10 PM GMT+1 (fwhite)
# Last Modified:    $Date: 2009-11-14 22:15:20 +0100 (Sat, 14 Nov 2009) $ $Author: fwhite $
# Notice:           Please maintain this section
#########################################################################################################
*/

error_reporting(E_ALL);
ini_set('display_errors', '1');

    function DBinfo()
    {
    return file_get_contents('html/db.html');
    }

    function UpgradeDBinfo()
    {
    return file_get_contents('html/upgrade_db.html');
    }

    function InstallorUpgrade()
    {
    return file_get_contents('html/decide.html');
    }

    function whereis($cmd)
    {
    $check = exec('whereis "'.$cmd.'"');
    if(preg_match("[/]", $check))
    {
    return $check;
    }
    else
    {
    return 0;
    }
    }

    function FilterArray($value)
    {
    if(preg_match('/share/i', $value) || preg_match('/:/', $value) ||
    preg_match('/etc/', $value)|| preg_match('/lib/', $value) ||
    preg_match('/include/', $value) || preg_match('/src/', $value)
    || preg_match('/man/', $value))
    {
    return false;
    }
    return true;
    }

    function LocCheck($bin)
    {
    $check  = whereis($bin);
    if($check)
    {
    $check      = explode(' ',$check);
    $result     = count(array_filter($check,'FilterArray'));
    if($result < 2)
    {
    return array_filter($check,'FilterArray');
    }
    else
    {
    $new        = array();
    $filtered   = array_filter($check,'FilterArray');
    $filtered   = array_merge((array)$new, (array)$filtered);
    return $filtered;
    }
    }
    $check  = array('Not Installed');
    return $check;
    }

    function FFmpegCheck()
    {
    if(defined('NO_FFMPEG'))
    {
    return file_get_contents('html/ffmpeg.html');
    }
    }

    function GetServerProtocol()
    {
    if(isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on')
    {
    return 'https://';
    }
    else
    {
    $protocol = preg_replace('/^([a-z]+)\/.*$/', '\\1', strtolower($_SERVER['SERVER_PROTOCOL']));
    $protocol .= '://';
    return $protocol;
    }
    }

    function GetServerURL()
    {
    return GetServerProtocol().$_SERVER['HTTP_HOST'].dirname($_SERVER['PHP_SELF']);
    }

    function GetBaseDir()
    {
    $pathParts 	    = pathinfo($_SERVER['SCRIPT_FILENAME']);
    $basedirPath 	= $pathParts['dirname'];
    return $basedirPath;
    }

    function which($cmd)
    {
    $check = exec('which "'.$cmd.'"');
    if(empty($check) || is_null($check))
    {
    return false;
    }
    else
    {
    return $check;
    }
    }

    function delTree($dir) {
    if ($handle = opendir($dir))
    {
    $array = array();
    while (false !== ($file = readdir($handle))) {
        if ($file != "." && $file != "..") {

			if(is_dir($dir.$file))
			{
				if(!@rmdir($dir.$file)) // Empty directory? Remove it
				{
                delTree($dir.$file.'/'); // Not empty? Delete the files inside it
				}
			}
			else
			{
               @unlink($dir.$file);
			}
        }
    }
    closedir($handle);

	@rmdir($dir);
    }
    }

/*    function CheckCHMOD()
    {
    IsCacheWritable();
    IsFilesWritable();
    IsFilesSubDirsWritable();
    IsImagesWritable();
    IsImagesSubDirsWritable();
    IsLogsWritable();
    IsDBConnectWritable();
    IsInstallWritable();
    }*/

    function CheckCHMOD()
    {
    if(is_array(VerifyPerms()))
    {
    $error  = VerifyPerms();
    $res    = array();
    foreach($error as $key => $value)
    {
    array_push($res,"<img src=\"images/icons/exclamation.png\" border=\"0\"> ".$value."<BR>");
    }
    define('CHMOD_ERROR','File permissions error (CHMOD)');
    $errorDoc       = file_get_contents(BASEDIR.'/error_pages/error.html');
    $errorDoc       = str_replace('$title', CHMOD_ERROR, $errorDoc);
    $errorDoc       = str_replace('$msg', implode("",$res), $errorDoc);
    $errorDoc       = str_replace('$res', 'CHMOD 0777 the directories &
    files specified above<BR><BR>
    <button type="button" onClick="location.href=\'index.php\'">Retry</button>', $errorDoc);
    echo $errorDoc;
    exit;
    }
    }

    function IsCacheWritable()
    {
    if(!is_writable(BASEDIR.'/cache'))
    {
    $basedirPath 	= BASEDIR;
    define('CACHE_ERROR','cache directory not writeable');
    $errorDoc       = file_get_contents($basedirPath.'/error_pages/error.html');
    $errorDoc       = str_replace('$title', 'cache directory not writeable', $errorDoc);
    $errorDoc       = str_replace('$msg', CACHE_ERROR, $errorDoc);
    $errorDoc       = str_replace('$res', 'Insure '.$basedirPath.'/cache is writeable
    (CHMOD 0777)', $errorDoc);
    echo $errorDoc;
    exit;
    }
    }

    function IsFilesWritable()
    {
    if(!is_writable(BASEDIR.'/files'))
    {
    $basedirPath 	= BASEDIR;
    define('FILES_ERROR','files directory not writeable');
    $errorDoc       = file_get_contents($basedirPath.'/error_pages/error.html');
    $errorDoc       = str_replace('$title', 'files directory not writeable', $errorDoc);
    $errorDoc       = str_replace('$msg', FILES_ERROR, $errorDoc);
    $errorDoc       = str_replace('$res', 'Insure '.$basedirPath.'/files is writeable
    (CHMOD 0777)', $errorDoc);
    echo $errorDoc;
    exit;
    }
    }

    function IsFilesSubDirsWritable()
    {
    $dir        = BASEDIR.'/files';
    $fileDirs   = scandir($dir);
    foreach($fileDirs as $key => $value)
    {
    if(is_dir(BASEDIR.'/files/'.$value) && $value != '..' && $value != '.')
    {
    if(!is_writable(BASEDIR.'/files/'.$value))
    {
    $basedirPath 	= BASEDIR;
    define('FILES_ERROR','files/'.$value.' directory not writeable');
    $errorDoc       = file_get_contents($basedirPath.'/error_pages/error.html');
    $errorDoc       = str_replace('$title', 'files/'.$value.' directory not writeable', $errorDoc);
    $errorDoc       = str_replace('$msg', FILES_ERROR, $errorDoc);
    $errorDoc       = str_replace('$res', 'Insure '.$basedirPath.'/files/'.$value.' is writeable
    (CHMOD 0777)', $errorDoc);
    echo $errorDoc;
    exit;
    }
    }
    }
    if(!is_writable(BASEDIR.'/files/temp/install.me'))
    {
    $basedirPath 	= BASEDIR;
    define('FILES_ERROR','files/temp/install.me not writeable');
    $errorDoc       = file_get_contents($basedirPath.'/error_pages/error.html');
    $errorDoc       = str_replace('$title', 'files/temp/install.me not writeable', $errorDoc);
    $errorDoc       = str_replace('$msg', FILES_ERROR, $errorDoc);
    $errorDoc       = str_replace('$res', 'Insure files/temp/install.me is writeable
    (CHMOD 0777)', $errorDoc);
    echo $errorDoc;
    exit;
    }
    }

    function IsImagesWritable()
    {
    if(!is_writable(BASEDIR.'/images'))
    {
    $basedirPath 	= BASEDIR;
    define('FILES_ERROR','images directory not writeable');
    $errorDoc       = file_get_contents($basedirPath.'/error_pages/error.html');
    $errorDoc       = str_replace('$title', 'images directory not writeable', $errorDoc);
    $errorDoc       = str_replace('$msg', FILES_ERROR, $errorDoc);
    $errorDoc       = str_replace('$res', 'Insure '.$basedirPath.'/images is writeable
    (CHMOD 0777)', $errorDoc);
    echo $errorDoc;
    exit;
    }
    }

    function IsImagesSubDirsWritable()
    {
    $dir        = BASEDIR.'/images';
    $fileDirs   = scandir($dir);
    foreach($fileDirs as $key => $value)
    {
    if(is_dir(BASEDIR.'/images/'.$value) && $value != '..' && $value != '.')
    {
    if(!is_writable(BASEDIR.'/images/'.$value))
    {
    $basedirPath 	= BASEDIR;
    define('FILES_ERROR','images/'.$value.' directory not writeable');
    $errorDoc       = file_get_contents($basedirPath.'/error_pages/error.html');
    $errorDoc       = str_replace('$title', 'images/'.$value.' directory not writeable', $errorDoc);
    $errorDoc       = str_replace('$msg', FILES_ERROR, $errorDoc);
    $errorDoc       = str_replace('$res', 'Insure '.$basedirPath.'/images/'.$value.' is writeable
    (CHMOD 0777)', $errorDoc);
    echo $errorDoc;
    exit;
    }
    }
    }
    }

    function IsLogsWritable()
    {
    if(!is_writable(BASEDIR.'/logs'))
    {
    $basedirPath 	= BASEDIR;
    define('FILES_ERROR','logs directory not writeable');
    $errorDoc       = file_get_contents($basedirPath.'/error_pages/error.html');
    $errorDoc       = str_replace('$title', 'logs directory not writeable', $errorDoc);
    $errorDoc       = str_replace('$msg', FILES_ERROR, $errorDoc);
    $errorDoc       = str_replace('$res', 'Insure '.$basedirPath.'/logs is writeable
    (CHMOD 0777)', $errorDoc);
    echo $errorDoc;
    exit;
    }
    if(!is_writable(BASEDIR.'/logs/curl'))
    {
    $basedirPath 	= BASEDIR;
    define('FILES_ERROR','logs/curl directory not writeable');
    $errorDoc       = file_get_contents($basedirPath.'/error_pages/error.html');
    $errorDoc       = str_replace('$title', 'logs/curl directory not writeable', $errorDoc);
    $errorDoc       = str_replace('$msg', FILES_ERROR, $errorDoc);
    $errorDoc       = str_replace('$res', 'Insure '.$basedirPath.'/logs/curl is writeable
    (CHMOD 0777)', $errorDoc);
    echo $errorDoc;
    exit;
    }
    if(!is_writable(BASEDIR.'/logs/videnc'))
    {
    $basedirPath 	= BASEDIR;
    define('FILES_ERROR','logs/videnc directory not writeable');
    $errorDoc       = file_get_contents($basedirPath.'/error_pages/error.html');
    $errorDoc       = str_replace('$title', 'logs/videnc directory not writeable', $errorDoc);
    $errorDoc       = str_replace('$msg', FILES_ERROR, $errorDoc);
    $errorDoc       = str_replace('$res', 'Insure '.$basedirPath.'/logs/videnc is writeable
    (CHMOD 0777)', $errorDoc);
    echo $errorDoc;
    exit;
    }
    }

    function IsDBConnectWritable()
    {
    if(!is_writable(BASEDIR.'/includes/dbconnect.php'))
    {
    $basedirPath 	= BASEDIR;
    define('FILES_ERROR','includes/dbconnect.php not writeable');
    $errorDoc       = file_get_contents($basedirPath.'/error_pages/error.html');
    $errorDoc       = str_replace('$title', 'includes/dbconnect.php not writeable', $errorDoc);
    $errorDoc       = str_replace('$msg', FILES_ERROR, $errorDoc);
    $errorDoc       = str_replace('$res', 'Insure '.$basedirPath.'/includes/dbconnect.php
     is writeable
    (CHMOD 0777)', $errorDoc);
    echo $errorDoc;
    exit;
    }
    }

    function IsInstallWritable()
    {
    if(!is_writable(BASEDIR.'/install'))
    {
    $basedirPath 	= BASEDIR;
    define('INSTALL_ERROR','install directory not writeable');
    $errorDoc       = file_get_contents($basedirPath.'/error_pages/error.html');
    $errorDoc       = str_replace('$title', 'install directory not writeable', $errorDoc);
    $errorDoc       = str_replace('$msg', INSTALL_ERROR, $errorDoc);
    $errorDoc       = str_replace('$res', 'Insure '.$basedirPath.'/install is writeable
    (CHMOD 0777)', $errorDoc);
    echo $errorDoc;
    exit;
    }
    }

    function GetPerms($res)
    {
    return substr(sprintf('%o', fileperms($res)), -4);
    }

    function VerifyPerms()
    {
    if(!defined('BASEDIR'))
    {
    define('BASEDIR',str_replace('/install','',GetBaseDir()));
    }
    $check  = array();
    $res    = array();
    $files  = array(BASEDIR.'/cache',BASEDIR.'/install',BASEDIR.'/includes/dbconnect.php',
    BASEDIR.'/files',BASEDIR.'/files/original',BASEDIR.'/files/temp',BASEDIR.'/files/thumbs',
    BASEDIR.'/files/videos',BASEDIR.'/files/temp/install.me',BASEDIR.'/logs',BASEDIR.'/logs/curl',
    BASEDIR.'/logs/videnc',BASEDIR.'/images',BASEDIR.'/images/avatars',BASEDIR.'/images/backgrounds',
    BASEDIR.'/images/category_thumbs',BASEDIR.'/images/groups_thumbs',
    BASEDIR.'/images/icons');
    foreach($files as $key => $value)
    {
    //$check[$value." (".GetPerms($value).")"] = CanWrite($value);
    $check[$value." (".GetPerms($value).")"] = is_writable($value);
    }
    foreach($check as $key => $value)
    {
    if($value != 1)
    {
    array_push($res,$key." is not writable");
    }
    }
    if(in_array(0,$res))
    {
    return $res;
    }
    }

    function CanWrite($res)
    {
    if(GetPerms($res) == '0777')
    {
    return 1;
    }
    return 0;
    }

    function OutputError($title,$error,$resolution)
    {
    define('ERROR',$error);
    $errorDoc       = file_get_contents(BASEDIR.'/error_pages/error.html');
    $errorDoc       = str_replace('$title', $title, $errorDoc);
    $errorDoc       = str_replace('$msg', ERROR, $errorDoc);
    $errorDoc       = str_replace('$res', $resolution, $errorDoc);
    echo $errorDoc;
    exit;
    }

    function OutputMessage($title,$message,$explain)
    {
    $Doc        = file_get_contents('html/setup.html');
    $Doc        = str_replace('$version', VERSION.' (r'.BUILD.')', $Doc);
    $Doc        = str_replace('$step', $title, $Doc);
    $Doc        = str_replace('$Explain', $message, $Doc);
    $Doc        = str_replace('$instruct', $explain, $Doc);
    echo $Doc;
    }

    function CheckPHPiniInteger($mb,$value)
    {
    $check  = ini_get($value);
    if(preg_match('/M/i', $check))
    {
    $check = str_replace('M','',$check);
    if($mb > $check)
    {
    return 1;
    }
    }
    elseif(preg_match('/G/i', $check))
    {
    $check = str_replace('G','',$check);
    $check = $check * 1024;
    if($mb > $check)
    {
    return 1;
    }
    }
    elseif(preg_match('/K/i', $check))
    {
    $mb = $mb * 8192;
    $check = str_replace('K','',$check);
    if($mb > $check)
    {
    return 1;
    }
    }
    else
    {
    $mb = $mb * 1048576;
    if($mb > $check)
    {
    return 1;
    }
    }
    }

    function GetMySQLColumns($table) {
        // LIMIT 1 means to only read rows before row 1 (0-indexed)
        $result     = mysql_query("SELECT * FROM $table LIMIT 1");
        $describe   = mysql_query("SHOW COLUMNS FROM $table");
        $num        = mysql_num_fields($result);
        $output     = array();
        for ($i = 0; $i < $num; ++$i) {
                $field = mysql_fetch_field($result, $i);
                // Analyze 'extra' field
                $field->auto_increment = (strpos(mysql_result($describe, $i, 'Extra'), 'auto_increment') === FALSE ? 0 : 1);
                // Create the column_definition
                $field->definition = mysql_result($describe, $i, 'Type');
                if ($field->not_null && !$field->primary_key) $field->definition .= ' NOT NULL';
                if ($field->def) $field->definition .= " DEFAULT '" . mysql_real_escape_string($field->def) . "'";
                if ($field->auto_increment) $field->definition .= ' AUTO_INCREMENT';
                if ($key = mysql_result($describe, $i, 'Key')) {
                        if ($field->primary_key) $field->definition .= ' PRIMARY KEY';
                        else $field->definition .= ' UNIQUE KEY';
                }
                // Create the field length
                $field->len = mysql_field_len($result, $i);
                // Store the field into the output
                $output[$field->name] = $field;
        }
        return array_keys($output);
    }

    function GetDisabledFunctions()
    {
    $check = explode(" ", ini_get('disable_functions'));
    return $check;
    }        

?>