// $Id: lightsoff.js 235 2009-08-25 12:39:17Z fwhite $
function getPageSize() {
	var xScroll, yScroll;
	if (window.innerHeight && window.scrollMaxY) {	
		xScroll = window.innerWidth + window.scrollMaxX;
		yScroll = window.innerHeight + window.scrollMaxY;
	} else if (document.body.scrollHeight > document.body.offsetHeight){ // all but Explorer Mac
		xScroll = document.body.scrollWidth;
		yScroll = document.body.scrollHeight;
	} else { // Explorer Mac...would also work in Explorer 6 Strict, Mozilla and Safari
		xScroll = document.body.offsetWidth;
		yScroll = document.body.offsetHeight;
	}
	var windowWidth, windowHeight;
	if (self.innerHeight) {	// all except Explorer
		if(document.documentElement.clientWidth){
			windowWidth = document.documentElement.clientWidth; 
		} else {
			windowWidth = self.innerWidth;
		}
		windowHeight = self.innerHeight;
	} else if (document.documentElement && document.documentElement.clientHeight) { // Explorer 6 Strict Mode
		windowWidth = document.documentElement.clientWidth;
		windowHeight = document.documentElement.clientHeight;
	} else if (document.body) { // other Explorers
		windowWidth = document.body.clientWidth;
		windowHeight = document.body.clientHeight;
	}	
	// for small pages with total height less then height of the viewport
	if(yScroll < windowHeight){
		pageHeight = windowHeight;
	} else { 
		pageHeight = yScroll;
	}
	// for small pages with total width less then width of the viewport
	if(xScroll < windowWidth){	
		pageWidth = xScroll;		
	} else {
		pageWidth = windowWidth;
	}
	arrayPageSize = new Array(pageWidth,pageHeight,windowWidth,windowHeight);
	return arrayPageSize;
}

function lightsoff() {
	$jQuery("#lightsoff").click(
	 function() {
	 	$jQuery('#videoplayer, embed, object')
		.css({ 'visibility' : 'visible' });
		$jQuery('body')
		.append('<div id="lightsoff-background"></div>');

		var page_size = getPageSize();
		
		$jQuery('#lightsoff-background')
		.css({
			backgroundColor:	"#000",
			opacity:			0.9,
			width:				page_size[2],
			height:				page_size[1]
		}).show();

		$jQuery('#lightsoff-background').click(function() {
			$jQuery('#lightsoff-background')
			.fadeOut(function() { 
				$jQuery('#lightsoff-background').remove(); 
			});
			return false;
		});
		return false;
	 });
}