<?php

///////////////////////////////////////////////////////////////////////////////////////
// PHPmotion                                                http://www.phpmotion.com //
///////////////////////////////////////////////////////////////////////////////////////
// License: You are not to sell or distribute this software without permission       //
// Help and support please visit http://www.phpmotion.com                            //
// Copyright All Rights Reserved                                                     //
///////////////////////////////////////////////////////////////////////////////////////

include_once ('classes/config.php');
include_once ('classes/sessions.php');

////////////////////////////////////////////////
// do not change !!
$convert_date	= date("D - M d, Y @ h:i A");
$debug_log_file	= 'logs/convertor_log.txt';
$admin_email	= $config['admin_notify_email'];
$skip_flv_check	= false;

// exclude anyone that does not have an user id
if ( $_SESSION['user_id'] == '' ) {
	//header('Location: index.php');
	//die();
}

$file_contents	= '';
// are we loading this as a url OR debugging
$ffmpeg_debug	= $_GET['debug'];

$config['video_watermark_image']= $config['site_base_url'].'image_s/site_name_logo.png';

// load dynamic convertor settings
$watermark				= $config['video_watermark'];
$watermark_image			= $config['video_watermark_image'];
$watermark_location		= $config['video_watermark_place'];

$resize				= $config['video_resize'];
$num_pass				= $config['video_convert_pass'];

$ffmpeg_size			= $config['video_ffmpeg_size'];
$bit_rate				= $config['video_ffmpeg_bit_rate'];
$ffmpeg_audio_rate		= $config['video_ffmpeg_audio_rate'];
$qmax					= $config['video_ffmpeg_qmax'];

$hq_on				= $config['video_ffmpeg_high_quality'];
$hq_setting				= $config['video_ffmpeg_hq'];
$hq_size				= $config['video_ffmpeg_hq_size'];

$vbitrate				= $config['video_mencoder_vbitrate'];
$scale				= $config['video_mencoder_scale'];
$srate				= $config['video_mencoder_srate'];
$mencoder_audio_rate		= $config['video_mencoder_audio_rate'];

///////////////////////////////////////////////////////////////////////
// some constants for now
$frame_rate				= 29.97;
$aspect				= '4:3'; 						// this should be dynamic maybe \\??// => -aspect 4:3

// end convertor settings


// set file paths
$base_path 		= installation_paths();
$ffmpeg_path 	= $config['path_to_ffmpeg'];
$flvtool2_path	= $config['path_to_flvtool2'];
$mencoder_path 	= $config['path_to_mencoder'];

//LOG THAT THIS PAGE WAS LOADED (debugging for CLI)
if ( $log_encoder == 'yes' ) {

    	$file_contents = "\n\n" . 'PHPmotion Convertor.php debug' . "\n" .
    						'CLI for convertor OK' . "\n" . $convert_date . "\n" .
        					'================================================================================' . "\n";
      write_debug_log($file_contents);
}

$file_contents	= '';


// PROCESS VIDEOS ONE BY ONE

$sql = "SELECT video_id FROM videos where approved = 'pending_conversion'";
$query = @mysql_query($sql);

while ($result = @mysql_fetch_array($query)) {

	$raw_video = $result['video_id'];

    	//set current video to "converting"
    	$sql1 = "UPDATE videos SET approved = 'converting' WHERE video_id = '$raw_video'";
    	@mysql_query($sql1);

    	$raw_video_path					= $base_path . '/uploads/avi/' . $raw_video;					// full path of raw video file
    	list($file_name_no_extension, $extension) = @split('\.', $raw_video);								// split raw video file name to get unique name
    	$avi_file 						= $base_path . '/uploads/avi/' . $file_name_no_extension . '.avi';
    	$new_flv 						= $base_path . '/uploads/' . $file_name_no_extension . '.flv';

    	$conversion_error = false;

    	/////////////////////////////////////////////////////////////
    	//                        STEP 1                           //
    	//                  encode video to flv                    //
    	/////////////////////////////////////////////////////////////

    	switch ($extension) {

    		case 'wmv':

            	if ( $resize == 'yes' ) {

            		$ffmpeg_cmd2 = "$config[path_to_ffmpeg] -i $raw_video_path -ab 64 -ar $ffmpeg_audio_rate -b $bit_rate -r $frame_rate -nr 1000 -g 500 -s $ffmpeg_size -qmax $qmax $new_flv";
            		@exec("$ffmpeg_cmd2");

            	} else {

            		$ffmpeg_cmd2 = "$config[path_to_ffmpeg] -i $raw_video_path -ab 64 -ar $ffmpeg_audio_rate -b $bit_rate -r $frame_rate -nr 1000 -g 500 -qmax $qmax $new_flv";
            		@exec("$ffmpeg_cmd2");
            	}


            	$debug_1 = $ffmpeg_cmd2 . "\n";
            	foreach ($output as $outputline) {
            		$debug_1 = $debug_1 . $outputline . "\n";
                		if ($debugmodex == 1) {
                			echo ("$outputline<br>");
                		}
                	}

                	//LOG THAT STEP 1 was ok
                	if ( $log_encoder == 'yes' ) {

                		$file_contents = 	'PHPmotion Step 1 Converting' . "\n" . $ffmpeg_cmd2 . "\n" . $convert_date . "\n" .
                    				'Command was executed.See rest of log for output details' . "\n" .
                    				'=================================================================' . "\n";

                    	write_debug_log($file_contents);
            	}

            	$file_contents	= '';
            	$output		= '';
            	$outputline		= '';


            	// check that conversion completed
            	if ( !file_exists($new_flv) || filesize($new_flv) < 100000 ) $conversion_error = true;

            break;

            case 'avi':

            	if ( $resize == 'yes' ) {

            		$ffmpeg_cmd2 = "$config[path_to_ffmpeg] -i $raw_video_path -ab 64 -ar $ffmpeg_audio_rate -b $bit_rate -r $frame_rate -nr 1000 -g 500 -s $ffmpeg_size -qmax $qmax $new_flv";
            		@exec("$ffmpeg_cmd2");

            	} else {

            		$ffmpeg_cmd2 = "$config[path_to_ffmpeg] -i $raw_video_path -ab 64 -ar $ffmpeg_audio_rate -b $bit_rate -r $frame_rate -nr 1000 -g 500 -qmax $qmax $new_flv";
            		@exec("$ffmpeg_cmd2");
            	}


            	//$ffmpeg_cmd2 = "$config[path_to_ffmpeg] -i $raw_video_path -ab 64 -ar 44100 -b 3000k -r 29.97 -s 560x420 -qmax 3 $new_flv";


            	@exec("$ffmpeg_cmd2");

		      $debug_1 = $ffmpeg_cmd2 . "\n";
		      foreach ($output as $outputline) {
		          	$debug_1 = $debug_1 . $outputline . "\n";
		           	if ($debugmodex == 1) {
		           		echo ("$outputline<br>");
		           	}
		      }

		      //LOG THAT STEP 1 was ok
		      if ( $log_encoder == 'yes' ) {

		          	$file_contents = 	'PHPmotion Step 1 Converting' . "\n" . $ffmpeg_cmd2 . "\n" . $convert_date . "\n" .
		           				'Command was executed. See rest of log for output details' . "\n" .
		           				'=================================================================' . "\n";

		           	write_debug_log($file_contents);
		      }

		      $file_contents	= '';
            	$output		= '';
            	$outputline		= '';

            	// check that conversion completed
            	if ( !file_exists($new_flv) || filesize($new_flv) < 100000 ) $conversion_error = true;

            break;

        	////////////////////// MPG //////////////////////////
        	case 'mpg':

            	if ( $resize == 'yes' ) {

            		$ffmpeg_cmd2 = "$config[path_to_ffmpeg] -i $raw_video_path -ab 64 -ar $ffmpeg_audio_rate -b $bit_rate -r $frame_rate -nr 1000 -g 500 -s $ffmpeg_size -qmax $qmax $new_flv";
            		@exec("$ffmpeg_cmd2");

            	} else {

            		$ffmpeg_cmd2 = "$config[path_to_ffmpeg] -i $raw_video_path -ab 64 -ar $ffmpeg_audio_rate -b $bit_rate -r $frame_rate -nr 1000 -g 500 -qmax $qmax $new_flv";
            		@exec("$ffmpeg_cmd2");
            	}


            	//$ffmpeg_cmd2 = "$config[path_to_ffmpeg] -i $raw_video_path -ab 64 -ar 44100 -b 2000k -r 29.97 -qmax 2 -aspect $aspect $new_flv";


	            @exec("$ffmpeg_cmd2");

            	$debug_1 = $ffmpeg_cmd2 . "\n";

            	foreach ($output as $outputline) {
                		$debug_1 = $debug_1 . $outputline . "\n";
                		if ($debugmodex == 1) {
                    		echo ("$outputline<br>");
                		}
            	}

            	if ( $log_encoder == 'yes' ) {

		          	$file_contents = 	'PHPmotion Step 1 Converting' . "\n" . $ffmpeg_cmd2 . "\n" . $convert_date . "\n" .
		           				'Command was executed. See rest of log for output details' . "\n" .
		           				'=================================================================' . "\n";

		           	write_debug_log($file_contents);
		      }

		      $file_contents	= '';
            	$output		= '';
            	$outputline		= '';

            	// check that conversion completed
            	if ( !file_exists($new_flv) || filesize($new_flv) < 100000 ) $conversion_error = true;

        	break;

            ////////////////////// IF UPLOAD IS FLV  check codec and convert OR JUST COPY IT ///////////////////

            case 'flv':

            	// we need to test flv codec here as FFMPEG / FLVTOOL2 will not decode default server setups On2-VP6 Video codec
            	$flv_codec_check = "$flvtool2_path -UP $raw_video_path | grep duration";

            	@exec("$flv_codec_check 2>&1", $output);

            	if ( sizeof($output) == 0 ) {

            		$skip_flv_check = true;

            		// most likely flvtool2 failed due to On2-VP6 codec - so run mencoder and convert to FLV1 codec
            		$mencoder_cmd = "$mencoder_path $raw_video_path -o $new_flv -of lavf -oac mp3lame -lameopts abr:br=56 -ovc lavc -lavcopts vcodec=flv:vbitrate=1000:mbd=2:mv0:trell:v4mv:cbp:last_pred=3 -lavfopts i_certify_that_my_video_stream_does_not_use_b_frames";
            		@exec("$mencoder_cmd 2>&1", $output);

            		foreach ($output as $outputline) {

            			$debug_1 = $debug_1 . $outputline . "\n";

            			if ($debugmodex == 1) echo ("$outputline<br>");

            		}

            		if ( @preg_match('/Unsupported video codec/', $debug_1, $regs) ) $fail_reasons = 'Unsupported Video Codec';
          			if ( filesize($new_flv) > 0 && filesize($new_flv) < 100000 ) $security_alerts = 'The uploaded video file size was too small, please check file for a hacking attempt';
          			if ( !file_exists($new_flv) || filesize($new_flv) < 100000 ) $conversion_error = true;


            	} else {
            		// we just copy flv
            		@copy( $raw_video_path, $new_flv );
            	}

            	if ( $log_encoder == 'yes' ) {

		          	$file_contents = 	'PHPmotion Step 1 Converting FLV was On2-VP6' . "\n" . $flv_codec_check . "\n" . $mencoder_cmd . "\n" .
		           				'Command was executed. See rest of log for output details' . "\n" .
		           				$debug_1 . "\n" .
		           				'=================================================================' . "\n";

		           	write_debug_log($file_contents);
		      }

		      $file_contents	= '';
            	$output		= '';
            	$outputline		= '';

          		// check that conversion completed

          		if ( $skip_flv_check == false ) {
          			if ( @preg_match('/Could not find codec parameters/', $debug_1, $regs) ) $fail_reasons = 'Unsupported Video Codec';
          			if ( filesize($new_flv) > 0 && filesize($new_flv) < 100000 ) $security_alerts = 'The uploaded video file size was too small, please check file for a hacking attempt';
          			if ( !file_exists($new_flv) || filesize($new_flv) < 100000 ) $conversion_error = true;
          		}

            break;

            ////////////////////////// IF OTHER VIDEO TYPE USE MENCODER e.g. RM TODO add types here ///////////////
            default:

            	$mencoder_cmd = "$mencoder_path $raw_video_path -o $new_flv -of lavf -oac mp3lame -lameopts abr:br=56 -ovc lavc -lavcopts vcodec=flv:vbitrate=800:mbd=2:mv0:trell:v4mv:cbp:last_pred=3 -lavfopts i_certify_that_my_video_stream_does_not_use_b_frames -vf scale=560:420 -srate 22050";
            	@exec("$mencoder_cmd 2>&1", $output);

            	// if no flv was created. try -vop swicth and not -vf
            	if ( !file_exists($new_flv) ) {
            		$mencoder_cmd = "$mencoder_path $raw_video_path -o $new_flv -of lavf -oac mp3lame -lameopts abr:br=56 -ovc lavc -lavcopts vcodec=flv:vbitrate=800:mbd=2:mv0:trell:v4mv:cbp:last_pred=3 -lavfopts i_certify_that_my_video_stream_does_not_use_b_frames -vop scale=560:420 -srate 22050";
                		@exec("$mencoder_cmd 2>&1", $output);
            	}

            	// if no flv was created. try -lavcopts i_certify_etc_etc
            	if ( !file_exists($new_flv) ) {
            		$mencoder_cmd = "$mencoder_path $raw_video_path -o $new_flv -of lavf -oac mp3lame -lameopts abr:br=56 -ovc lavc -lavcopts vcodec=flv:vbitrate=800:mbd=2:mv0:trell:v4mv:cbp:last_pred=3 -vf scale=560:420 -srate 22050";
                		@exec("$mencoder_cmd 2>&1", $output);
            	}

            	$debug_1 = $mencoder_cmd . "\n";
            	foreach ( $output as $outputline ) {
            		$debug_1 = $debug_1 . $outputline . "\n";
            		if ($debugmodex == 1) {
            			echo ("$outputline<br>");
            		}
            	}

            	//LOG THAT STEP 1 was ok
            	if ($log_encoder == 'yes') {

            		$file_contents =	'PHPmotion Step 1 Converting - At case = default' . "\n" . $mencoder_cmd . "\n" . $convert_date . "\n" .
            					'Command was executed.See rest of log for output details' . "\n" .
            					'=================================================================' . "\n";

            		write_debug_log($file_contents);
            	}

            	$file_contents	= '';
            	$output		= '';
            	$outputline		= '';

            	// check that conversion completed
            	if ( !file_exists($new_flv) || filesize($new_flv) < 100000 ) $conversion_error = true;

            break;

	} // end upload extensions

	// ##############################################################################################################$$$$$
	//
	// if conversion error no need to continue

	if ( $conversion_error ) {

		die_with_msg( $config['site_name'] );

	} else {


    		//CHECK POINT 3\\
    		//mail("you@yourdomain.com", "PHPmotion - Check Point 3", "FLVTOOL2 : $flv_cmd", "From: Server <name@email.com>");

    		/////////////////////////////////////////////////////////////
    		//                        STEP 2 & 3
    		//			   FLVTOOL2 INJECTION
    		//					and
    		//                   get video duration			     //
    		/////////////////////////////////////////////////////////////

    		/////////////////////////////////////////////////////////////////////////////////////////
    		// flvtool2 -UP $new-flv	duration output is in total seconds => duration: 337.633 //
    		// ffmpeg -i $new_flv		duration output is in human time => Duration: 00:05:37.6 //
    		/////////////////////////////////////////////////////////////////////////////////////////

    		////////////////////////////////////////////////////////////////////
    		// dev debug testing - remove when released
    		/*
    		$flv_debug_duration = "$flvtool2_path -UP $new_flv";
    		@exec("$flv_debug_duration 2>&1", $output);
    		foreach ( $output as $outputline ) {
    			$debug_test = $debug_test . $outputline . "\n";
    		}
     		$output		= '';
     		$outputline		= '';
     		*/
     		///////////////////////////////////////////////////////////////////

    		$flv_duration_cmd = "$flvtool2_path -UP $new_flv | grep duration";
    		@exec("$flv_duration_cmd 2>&1", $output);

    		$output[0]			= str_replace('duration:', '', $output[0]);
    		$vid_duration		= trim($output[0]);
    		$vid_duration		= (int)$vid_duration;

    		// change total seconds to DB time e.g. 121 seconds == 00:02:01
    		$duration_hours		= floor($vid_duration / 3600);
    		$duration_mins		= floor($vid_duration % 3600 / 60);
    		$duration_secs		= floor($vid_duration % 60);
    		$duration_time 		= sprintf("%02d:%02d:%02d", $duration_hours, $duration_mins, $duration_secs);
    		$duration			= $duration_time;

    		// middle of movie
    		$thumb_pos		= (int)$vid_duration / 2;

    		// change total seconds to ffmpeg time e.g. 121 seconds == 00:02:01
    		$ffmpeg_hours		= floor($thumb_pos / 3600);
    		$ffmpeg_mins		= floor($thumb_pos % 3600 / 60);
    		$ffmpeg_secs		= floor($thumb_pos % 60);
    		$ffmpeg_time 		= sprintf("%02d:%02d:%02d", $ffmpeg_hours, $ffmpeg_mins, $ffmpeg_secs);
    		$thumb_position		= $ffmpeg_time;

    		foreach ($output as $outputline) {
      		$debug_2 = $debug_2 . $outputline . "\n";
      		if ($debugmodex == 1) {//no debug mode
            		echo ("$outputline<br>");
        		}
    		}

    		//LOG THAT STEP 3 was ok
    		if ($log_encoder == "yes") {

      		$file_contents = 	'PHPmotion STEP 2 & 3' . "\n" . 'OUTPUT - FLVTOOL2 - check - Video Duration = ' . $vid_duration . "\n" .
      				$debug_test . "\n" . '================================================================================'."\n" .
      				$flv_duration_cmd . "\n" . $debug_2;

            	write_debug_log($file_contents);
    		}

    		$file_contents	= '';
     		$output		= '';
     		$outputline		= '';

    		//CHECK POINT 4\\
    		//mail("you@yourdomain.com", "PHPmotion - Check Point 4", "FFMPEG-PHP : $duration", "From: Server <name@email.com>");

    		/////////////////////////////////////////////////////////////
    		//                        STEP 4                           //
    		//                  Create thumnail image                  //
    		/////////////////////////////////////////////////////////////

    		// TODO ADD MULTIPULE THUMB CODE HERE


    		$output_file = $base_path . '/uploads/thumbs/' . $file_name_no_extension . '.jpg';

    		// V3 or any template that uses video thumbnail in player if auto start = false create large thumbnail so player image is not pixelated

 		$player_output_file = $base_path . '/uploads/player_thumbs/' . $file_name_no_extension . '.jpg';

    		$ffmpeg_cmd2 = "$config[path_to_ffmpeg] -i $new_flv -ss $thumb_position -t 00:00:01 -s 120x90 -r 1 -f mjpeg $output_file";
    		@exec("$ffmpeg_cmd2 2>&1", $output);

		// create large thumb for better player image
    		$ffmpeg_cmd_lrg = "$config[path_to_ffmpeg] -i $new_flv -ss $thumb_position -t 00:00:01 -s 560x420 -r 1 -f mjpeg $player_output_file";
    		@exec("$ffmpeg_cmd_lrg 2>&1", $output);

    		// check if thumbnail was created
    		if ( !file_exists($output_file) ) {

    			// first check if flv was created and is more than 0 bytes
    	    		$ffmpeg_cmd2 = "$config[path_to_ffmpeg] -i $new_flv -ss $thumb_position -t 00:00:01 -s 120x90 -r 1 -f image2 $output_file";
       		@exec("$ffmpeg_cmd2 2>&1", $output);
    		}

    		//check if thumbnail is 0 bytes
    		if (filesize($output_file) == 0) {
      		$second = '00:00:12';
        		$ffmpeg_cmd2 = "$config[path_to_ffmpeg] -i $new_flv -deinterlace -an -ss $second -t 00:00:01 -s 120x90 -r 1 -y -vcodec mjpeg -f mjpeg $output_file";
        		@exec("$ffmpeg_cmd2 2>&1", $output);
    		}

   		foreach ( $output as $outputline ) {
    			$debug_thumb = $debug_thumb . $outputline . "\n";
    			if ($debugmodex == 1) echo ("$outputline<br>");
    		}

    		//LOG THAT STEP 4 was ok
    		if ($log_encoder == "yes") {

      		$file_contents = 	'PHPmotion Debug - STEP 4' . "\n" . $ffmpeg_cmd2 . "\n" . 'Command was executed.See rest of log for output details' . "\n" .
      				$debug_thumb . "\n" . '================================================================================' . "\n\n\n";

      		write_debug_log($file_contents);
      	}

      	$file_contents	= '';
     		$output		= '';
     		$outputline		= '';

    		// CHECK POINT 5\\
    		// mail("you@yourdomain.com", "PHPmotion - Check Point 5", "THUMBNAIL : $ffmpeg_cmd2", "From: Server <name@email.com>");

    		/////////////////////////////////////////////////////////////
    		//                        STEP 6                           //
    		//                  UDATE DATABASE DETAILS                 //
    		/////////////////////////////////////////////////////////////

    		$sql_test = 'SELECT * FROM admin';

    		if (!mysql_query($sql_test)) {
      		@mysql_close();
       	 	include_once('classes/config.inc.php');
        		include_once('classes/config.php');
        		@mysql_connect($hostname, $dbusername, $dbpassword, true);
        		@mysql_select_db($dbname);
    		}


    		// RESET THE VIDEO FROM "pending_conversion" to just "pending" (for admin approval etc)
    		$sql = "UPDATE videos SET approved='pending' WHERE video_id = '$raw_video'";
    		@mysql_query($sql);

    		// RESET THE VIDEO ID TO REMOVE file extenstion
    		$sql = "UPDATE videos SET video_id='$file_name_no_extension' WHERE video_id = '$raw_video'";
    		@mysql_query($sql);

    		// Update database with new duration information
    		$file_name_no_extension = $file_name_no_extension;
    		$sql = "UPDATE videos SET video_length='$duration' WHERE video_id = '$file_name_no_extension'";
    		@mysql_query($sql);

    		// Check if video need pre approval by admin, if not update from pending to "yes"
    		if ($config["auto_approve_videos"] == "yes") {
      		$sql = "UPDATE videos SET approved='yes' WHERE video_id = '$file_name_no_extension'";
        		@mysql_query($sql);
    		}

    		//delete original file and converted temp avi file
    		$original_file = $raw_video_path;

    		if ($config['delete_original'] == 'yes') {
      		if (@file_exists("$new_flv") && @file_exists("$raw_video_path")) {
      	    		if ($new_flv != $raw_video_path) {
                			@unlink($raw_video_path);
            		}
        		}
    		}

    		if ($config['delete_avi'] == 'yes') {
      		if (@file_exists("$new_flv") && @file_exists("$avi_file")) {
            		@unlink($avi_file);
        		}
    		}

    		@mysql_close();

    	} // end conversion error
} // end while


// sub functions

function die_with_msg($site_name) {

	global $admin_email, $fail_reasons, $security_alerts, $raw_video, $avi_file, $new_flv;

	$subject	= "Video Conversion Error";

	$message	= "The following uploaded video did not successfully convert " .
			   $raw_video . "\n\n" . "Reasons: " . $fail_reasons . "\n" .
			   "You can view the file in uploads/avi" . "\n" . $security_alerts;

	$to		= $admin_email;
      $from 	= $site_name;

      mail($to, $subject, $message, "From: $from");

      @unlink($new_flv);


      include_once ('classes/config.php');

      $sql		= "DELETE FROM videos WHERE video_id = '$raw_video'";
      $query	= @mysql_query($sql);

      if(!$query) {
      	$db_msg = "Error while during sql_query Error Output: <br/>" . mysql_errno() . " : " . mysql_error() . "<br/>" . "Query follows:<br/>" . $query;
		@mysql_close();
		write_debug_log($db_msg);
	}

	@mysql_close();

return true;

}



// write a log for each upload -- use new_flv as name ??
function write_debug_log($file_contents) {
	global $debug_log_file;

	if (@file_exists($debug_log_file)) {
    		$fo = @fopen($debug_log_file, 'a');
        	@fwrite($fo, $file_contents);
        	@fclose($fo);

    	} else {
      	$fo = @fopen($debug_log_file, 'w');
        	@fwrite($fo, $file_contents);
        	@fclose($fo);
    	}
return true;
}

function email__debug_log($check_point) {

	// mail("you@yourdomain.com", "PHPmotion - Check Point 3", "FLVTOOL2 : $flv_cmd", "From: Server <name@email.com>");

return true;
}




?>